<?php
/**
 * @var $module
 * @var $settings
 * @var $id
 */

$settings = apply_filters('labb_features_' . $id . '_settings', $settings);

$class = (($settings->tiled == 'yes') ? 'labb-tiled ' . $settings->container_class : $settings->container_class);

$output = '<div class="labb-features labb-container ' . esc_attr($class) . '">';

foreach ($settings->features as $feature):

    if (!is_object($feature))
        continue;

    $child_output = '<div class="labb-feature labb-image-text-toggle ' . esc_attr($feature->feature_class) . '">';

    list($animate_class, $animation_attr) = labb_get_animation_atts($feature->image_animation);

    $child_output .= '<div class="labb-feature-image labb-image-content ' . $animate_class . '" ' . $animation_attr . '>';

    if (!empty($feature->feature_image)):

        $size = isset($settings->image_size) ? $settings->image_size : 'large';

        $src = wp_get_attachment_image_src($feature->feature_image, $size);

        $photo_data = FLBuilderPhoto::get_attachment_data($feature->feature_image);

        // set params
        $photo_settings = array(
            'align' => 'center',
            'link_type' => '',
            'crop' => $settings->crop,
            'photo' => $photo_data,
            'photo_src' => $src[0],
            'photo_source' => 'library',
        );

        // render image
        $image_html = labb_get_image_html($photo_settings);;

        $child_output .= $image_html;

    endif;

    $child_output .= '</div><!-- .labb-feature-image -->';

    list($animate_class, $animation_attr) = labb_get_animation_atts($feature->text_animation);

    $child_output .= '<div class="labb-feature-text labb-text-content ' . $animate_class . '" ' . $animation_attr . '>';

    $child_output .= '<div class="labb-subtitle">' . esc_html($feature->feature_subtitle) . '</div>';

    $child_output .= '<' . esc_html($settings->title_tag) . ' class="labb-title">' . esc_html($feature->feature_title) . '</' . esc_html($settings->title_tag) . '>';

    $child_output .= '<div class="labb-feature-details">' . do_shortcode(wp_kses_post($feature->feature_text)) . '</div>';

    $child_output .= '</div><!-- .labb-feature-text -->';

    $child_output .= '</div><!-- .labb-feature -->';

    $output .= apply_filters('labb_feature_item_output', $child_output, $feature, $settings);

endforeach;

$output .= '</div><!-- .labb-features -->';

echo apply_filters('labb_features_output', $output, $settings);